/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.art.export.diagrams.util;

import com.ibm.xtools.umlnotation.UMLShape;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.uml2.uml.State;

public final class BorderPositionUtil {
    private static final String S = "S";
    private static final String E = "E";
    private static final String W = "W";
    private static final String N = "N";
    public static double STATE_DEFAULT_WIDTH = 80.0;
    public static double STATE_DEFAULT_HEIGHT = 50.0;

    private BorderPositionUtil() {
    }

    public static double[] computeWidthAndHeight(UMLShape parentContainer) {
        if (parentContainer == null) {
            return new double[]{0.0, 0.0};
        }
        LayoutConstraint lc = parentContainer.getLayoutConstraint();
        if (!(lc instanceof Bounds)) {
            return new double[]{0.0, 0.0};
        }
        Bounds b = (Bounds)lc;
        double w = MapModeUtil.getMapMode().LPtoDP(b.getWidth());
        double h = MapModeUtil.getMapMode().LPtoDP(b.getHeight());
        if (w < 0.0 && parentContainer.getElement() instanceof State) {
            w = STATE_DEFAULT_WIDTH;
        }
        if (h < 0.0 && parentContainer.getElement() instanceof State) {
            h = STATE_DEFAULT_HEIGHT;
        }
        return new double[]{w, h};
    }

    public static String computeBorderPositionCenterRelative(double w, double h, double px, double py) {
        String edge = null;
        if (py < 0.0) {
            edge = N;
        } else if (px < 0.0) {
            edge = W;
        } else if (py > 0.0) {
            edge = px > w / 2.0 && py < h / 2.0 ? E : S;
        }
        if (edge == null) {
            return null;
        }
        int minPercent = 10;
        if (w > 0.0 && (edge.equals(N) || edge.equals(S))) {
            minPercent = (int)(px / w * 100.0);
        } else if (h > 0.0 && (edge.equals(W) || edge.equals(E))) {
            minPercent = (int)(py / h * 100.0);
        }
        if (minPercent < 10) {
            minPercent = 10;
        } else if (minPercent > 90) {
            minPercent = 90;
        }
        return edge + minPercent;
    }
}

