/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.art.export.diagrams.actions;

import com.hcl.art.export.diagrams.util.BorderPositionUtil;
import com.hcl.art.export.diagrams.util.DiagramTextUtil;
import com.hcl.art.integration.core.exporter.ArtGenerator;
import com.hcl.rtistic.art.AllRTMiscUtils;
import com.hcl.rtistic.art.artlang.NamedElement;
import com.hcl.rtistic.art.diagrams.ArtDiagramType;
import com.hcl.rtistic.art.diagrams.Layout;
import com.hcl.rtistic.art.diagrams.LayoutSettings;
import com.ibm.xtools.uml.msl.internal.operations.NamespaceOperations;
import com.ibm.xtools.umlnotation.UMLConnector;
import com.ibm.xtools.umlnotation.UMLDiagramKind;
import com.ibm.xtools.umlnotation.UMLShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.BasicDecorationNode;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;

public class ExportStateMachineDiagramData {
    private Map<EObject, UMLShape> elementShapeMap = new HashMap<EObject, UMLShape>();

    public LayoutSettings getLayoutSettings(EObject sourceElement, Diagram diagram, EObject artElement) {
        LayoutSettings layoutSettings = new LayoutSettings(AllRTMiscUtils.getFullyQualifiedName((EObject)artElement), ArtDiagramType.STATE_DIAGRAM);
        EList children = diagram.getChildren();
        this.updateElementShapeMap((List<?>)children);
        this.addLayouts(layoutSettings, (List<?>)children);
        return layoutSettings;
    }

    private void updateElementShapeMap(List<?> children) {
        for (Object object : children) {
            UMLShape umlShape;
            EObject element;
            if (object instanceof UMLShape && (element = (umlShape = (UMLShape)object).getElement()) != null) {
                this.elementShapeMap.put(element, umlShape);
            }
            if (!(object instanceof Node)) continue;
            Node node = (Node)object;
            this.updateElementShapeMap((List<?>)node.getChildren());
        }
    }

    private void addLayouts(LayoutSettings layoutSettings, List<?> children) {
        for (Object object : children) {
            if (object instanceof UMLShape) {
                UMLShape umlShape = (UMLShape)object;
                element = umlShape.getElement();
                artElement = ArtGenerator.getInstance().getArtElementsCache().getArtElement(element);
                if (element instanceof State || element instanceof Pseudostate) {
                    elementName = element != null ? AllRTMiscUtils.getQualifiedNameWithinRootContainer((NamedElement)((NamedElement)artElement)) : null;
                    String string = elementName = (elementName == null || elementName.isEmpty()) && element instanceof Pseudostate && PseudostateKind.INITIAL_LITERAL.equals((Object)((Pseudostate)element).getKind()) ? "initial-state" : elementName;
                    if (elementName != null) {
                        layoutConstraint = umlShape.getLayoutConstraint();
                        if (this.isEntryExitPoint(element) && !this.isParentTypePresent((List)umlShape.getChildren())) continue;
                        if (layoutConstraint instanceof Bounds) {
                            double containerH;
                            UMLShape parentContainer;
                            double[] container;
                            double containerW;
                            String borderPos;
                            bounds = (Bounds)layoutConstraint;
                            layout = this.createLayout(elementName, bounds);
                            double w = MapModeUtil.getMapMode().LPtoDP(bounds.getWidth());
                            double h = MapModeUtil.getMapMode().LPtoDP(bounds.getHeight());
                            if (w == -1.0 && element instanceof State) {
                                w = DiagramTextUtil.computeStateWidth(elementName, BorderPositionUtil.STATE_DEFAULT_WIDTH);
                            }
                            if (h == -1.0 && element instanceof State) {
                                h = BorderPositionUtil.STATE_DEFAULT_HEIGHT;
                            }
                            if (w != -1.0) {
                                layout.w = w;
                            }
                            if (h != -1.0) {
                                layout.h = h;
                            }
                            if (this.isEntryExitPoint(element) && (borderPos = BorderPositionUtil.computeBorderPositionCenterRelative(containerW = (container = BorderPositionUtil.computeWidthAndHeight(parentContainer = this.elementShapeMap.get(element.eContainer())))[0], containerH = container[1], layout.x, layout.y)) != null) {
                                layout.borderPosition = borderPos;
                            }
                            layoutSettings.layouts.add(layout);
                        }
                    }
                }
                if (element instanceof State && !((State)element).getRegions().isEmpty()) {
                    this.addNestedStatemachineLayouts(layoutSettings, element);
                }
            } else if (object instanceof UMLConnector) {
                UMLConnector umlConnector = (UMLConnector)object;
                element = umlConnector.getElement();
                artElement = ArtGenerator.getInstance().getArtElementsCache().getArtElement(element);
                if (element instanceof Transition) {
                    String string = elementName = element != null ? AllRTMiscUtils.getFullyQualifiedName((EObject)artElement) : null;
                    if (elementName != null && (layoutConstraint = this.getLayoutConstraint(umlConnector)) instanceof Bounds) {
                        bounds = (Bounds)layoutConstraint;
                        layout = this.createLayout(elementName, bounds);
                        layoutSettings.layouts.add(layout);
                    }
                }
            }
            if (!(object instanceof Node)) continue;
            Node node = (Node)object;
            this.addLayouts(layoutSettings, (List<?>)node.getChildren());
        }
    }

    private boolean isParentTypePresent(List children) {
        for (Object object : children) {
            if (!(object instanceof DecorationNode)) continue;
            DecorationNode node = (DecorationNode)object;
            EList basicDecorationNodes = node.getChildren();
            for (Object childNodeObj : basicDecorationNodes) {
                if (!(childNodeObj instanceof BasicDecorationNode) || !"Parent".equals(((BasicDecorationNode)childNodeObj).getType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEntryExitPoint(EObject element) {
        return element instanceof Pseudostate && (PseudostateKind.EXIT_POINT_LITERAL.equals((Object)((Pseudostate)element).getKind()) || PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)((Pseudostate)element).getKind()));
    }

    private Layout createLayout(String elementName, Bounds bounds) {
        double x = MapModeUtil.getMapMode().LPtoDP(bounds.getX());
        double y = MapModeUtil.getMapMode().LPtoDP(bounds.getY());
        return new Layout(elementName, Double.valueOf(x), Double.valueOf(y));
    }

    private LayoutConstraint getLayoutConstraint(UMLConnector umlConnector) {
        EList children = umlConnector.getChildren();
        for (Object child : children) {
            DecorationNode node;
            LayoutConstraint layoutConstraint;
            if (!(child instanceof DecorationNode) || (layoutConstraint = (node = (DecorationNode)child).getLayoutConstraint()) == null) continue;
            return layoutConstraint;
        }
        return null;
    }

    private void addNestedStatemachineLayouts(LayoutSettings layoutSettings, EObject element) {
        List ownedDiagrams = NamespaceOperations.getOwnedDiagrams((Namespace)((Namespace)element), (boolean)false);
        for (Diagram diagram : ownedDiagrams) {
            if (!UMLDiagramKind.STATECHART_LITERAL.getLiteral().equals(diagram.getType())) continue;
            EList children = diagram.getChildren();
            for (Object diagram2 : children) {
                if (!(diagram2 instanceof UMLShape)) continue;
                this.addLayouts(layoutSettings, (List<?>)((UMLShape)diagram2).getChildren());
            }
        }
    }
}

