#! perl -w

# +------------------------------------------------------------------------+
# | Licensed Materials - Property of IBM                                   |
# |                                                                        |
# | com.ibm.xtools.umldt.rt.core.tools                                     |
# |                                                                        |
# | Copyright IBM Corporation 1991, 2011.  All Rights Reserved.            |
# |                                                                        |
# | U.S. Government Users Restricted Rights - Use, duplication or          |
# | disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      |
# +------------------------------------------------------------------------+

# Intended usage: perl cdrun.pl directory command ...
#
# A platform independent way of running a double command on one Makefile line.
# eg:
#    cd $DIR ; $CMD   (Unix)
#    cd $DIR & $CMD   (Windows)

# Unbuffer stdout
$| = 1;

if( $#ARGV < 1 ) {
	print STDERR "Usage: ${0} directory command ...\n";
	exit 1;
}

$dir = shift @ARGV;

chdir $dir or die "chdir [$dir] failed: $!\n";

# if the incoming ARGV had spaces, then
# replace the dquotes that the shell stripped out.
grep { s/^.*\s.*$/\"$&\"/ } @ARGV;

$status = system( @ARGV );

exit $status if( $status & 0xFF );
exit $status >> 8;
