#! perl -w

sub fatal
{
	print STDERR @_, "\n";
	exit 1;
}

sub expand
{
	my( $string ) = $_[ 0 ];
	my( $macro, $value );

	while( $string =~ m{\$\((\w+)\)} )
	{
		$macro = $1;

		&fatal( "Reference to undefined variable: '$macro'" )
			unless( $value = $ENV{$macro} );

		$string =~ s{\$\(\w+\)}{$value};
	}

	return $string;
}

$verbose = 0;

while( $#ARGV >= 0 )
{
	my( $arg ) = $ARGV[0];

	if( $arg eq '-verbose'  ) { $verbose  = 1; }
	else                      { last;          }
	shift @ARGV;
}

&fatal( "Usage: $0 [-verbose] make [options ...]" ) if $#ARGV < 0;

&fatal( "cannot open Makefile" ) unless( open FILE, "Makefile" );

$RTS_HOME    = $ENV{'RTS_HOME'};
$PLATFORM    = $ENV{'PLATFORM'};
$THREADED    = $ENV{'THREADED'};
$LIBRARY_SET = $ENV{'LIBRARY_SET'};

while( <FILE> )
{
	if (/^(RTS_HOME|PLATFORM|THREADED|LIBRARY_SET) *= *(.+)$/)	 
	{
		${$1} = $2;
	}
}

&fatal( "RTS_HOME is undefined") if not defined $RTS_HOME;
&fatal( "PLATFORM is undefined") if not defined $PLATFORM;
&fatal( "THREADED is undefined") if not defined $THREADED;
&fatal( "LIBRARY_SET is undefined") if not defined $LIBRARY_SET;

$CONFIG = "$PLATFORM$THREADED.$LIBRARY_SET";
$setup  = &expand( "$RTS_HOME/config/$CONFIG/setup.pl" );

&fatal( "Can't find $setup." ) unless -r $setup;

$| = 1;
print "Using setup for $CONFIG\n  from $RTS_HOME ...\n" if $verbose;

push @INC, expand( $RTS_HOME );

do "$setup"
	|| die "$0 failed\n";

$sep = ( $ENV{'OS'} || '?' ) eq 'Windows_NT' ? ';' : ':';
%cnt = ();
$ENV{'PATH'} = join( $sep, grep { ++$cnt{$_} == 1 } split( $sep, $ENV{'PATH'} ) );

$status = system( @ARGV );

exit $status if( $status & 0xFF );
exit $status >> 8;
