/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.rsarte.art.exporter;

import com.ibm.xtools.common.ui.wizards.FilteredFileSelectionDialog;
import com.ibm.xtools.common.ui.wizards.internal.NonVirtualContainerValidator;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ArtFileExportWizardPage
extends WizardDataTransferPage {
    private String filePath;
    private String selectedFile = null;
    private Text sourcePathField;
    static final String FILE_JS_EXT = "tcjs";
    private String[] sourceFileExtensions = new String[]{"tcjs"};
    private Button browseButtonForDirectory;
    private Text directoryDest;
    private Text wksSpaceDest;
    private Button browseButtonForWks;
    private Button wksSpaceButton;
    private Button directoryButton;
    private String defaultDirectoryPath;
    private Path defaultWorkspacePath;

    protected ArtFileExportWizardPage() {
        super("Export Model to Art");
        this.setTitle("Export Model to Art");
        this.setDescription("Select the transformation configuration file to export model to art");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.newContainerLayout(1));
        this.createSourceGroup(composite);
        this.createDestinationGroup(composite);
        this.setControl((Control)composite);
    }

    private void createDestinationGroup(Composite composite) {
        Group destGroup = new Group(composite, 0);
        destGroup.setLayout((Layout)this.newContainerLayout(3));
        destGroup.setText("Destination");
        destGroup.setLayoutData((Object)new GridData(768));
        this.wksSpaceButton = new Button((Composite)destGroup, 16);
        this.wksSpaceButton.setText("Workspace");
        this.wksSpaceButton.setSelection(false);
        this.wksSpaceButton.addListener(13, event -> this.setWorkspaceSelected(this.wksSpaceButton.getSelection()));
        this.wksSpaceDest = new Text((Composite)destGroup, 2048);
        this.wksSpaceDest.setText("");
        this.wksSpaceDest.setEnabled(false);
        this.wksSpaceDest.setLayoutData((Object)new GridData(768));
        this.wksSpaceDest.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtFileExportWizardPage.this.updatePageCompletion();
            }
        });
        this.browseButtonForWks = new Button((Composite)destGroup, 8);
        this.browseButtonForWks.setText("Browse...");
        this.browseButtonForWks.addListener(13, event -> this.handleBrowseWorkspaceButtonPressed());
        this.directoryButton = new Button((Composite)destGroup, 16);
        this.directoryButton.setText("Directory");
        this.directoryButton.setSelection(true);
        this.directoryButton.addListener(13, event -> this.setWorkspaceSelected(!this.directoryButton.getSelection()));
        this.directoryDest = new Text((Composite)destGroup, 2048);
        this.directoryDest.setLayoutData((Object)new GridData(768));
        this.directoryDest.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtFileExportWizardPage.this.updatePageCompletion();
            }
        });
        this.browseButtonForDirectory = new Button((Composite)destGroup, 8);
        this.browseButtonForDirectory.setText("Browse...");
        this.browseButtonForDirectory.addListener(13, event -> this.handleBrowseDirectoryButtonPressed());
    }

    private void handleBrowseDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        Path path = new Path(this.directoryDest.getText());
        File file = path.toFile();
        if (file != null && file.exists()) {
            dialog.setFilterPath(this.directoryDest.getText());
        }
        dialog.setMessage("Export to Directory");
        dialog.setText("Select a directory to export to");
        String selectedDirectoryName = dialog.open();
        if (selectedDirectoryName != null) {
            this.directoryDest.setText(selectedDirectoryName);
            this.updatePageCompletion();
        }
    }

    private void createSourceGroup(Composite composite) {
        Group srcGroup = new Group(composite, 0);
        srcGroup.setText("Source");
        srcGroup.setLayout((Layout)this.newContainerLayout(3));
        srcGroup.setLayoutData((Object)new GridData(768));
        Label filePathLabel = new Label((Composite)srcGroup, 0);
        filePathLabel.setText("Transformation Configuration:");
        this.sourcePathField = new Text((Composite)srcGroup, 2048);
        this.sourcePathField.setLayoutData((Object)new GridData(768));
        this.sourcePathField.addListener(24, event -> this.handleSourcePathModified());
        Button browseButton = new Button((Composite)srcGroup, 8);
        browseButton.setText("Browse...");
        browseButton.addListener(13, event -> this.handleBrowseSourceButtonPressed());
    }

    private void handleSourcePathModified() {
        String sourcePathStr;
        this.selectedFile = null;
        this.selectedFile = sourcePathStr = this.sourcePathField.getText().trim();
        this.updatePageCompletion();
    }

    private void handleBrowseSourceButtonPressed() {
        ElementTreeSelectionDialog dialog = this.createBrowseDialog();
        dialog.setTitle("Export Model File(s)");
        dialog.setMessage("Select the source model file(s) to export");
        dialog.setAllowMultiple(true);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ArrayList<IResource> listOfFiles = new ArrayList<IResource>();
        if (this.selectedFile != null) {
            Path filePath = new Path(this.selectedFile);
            if (workspace.getRoot().exists((IPath)filePath)) {
                IResource resource = workspace.getRoot().findMember((IPath)filePath);
                listOfFiles.add(resource);
            }
            dialog.setInitialSelections(listOfFiles.toArray());
        }
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            return;
        }
        Object[] resourceList = dialog.getResult();
        if (resourceList != null && resourceList.length > 0) {
            if (resourceList.length == 1) {
                IPath path = ((IResource)resourceList[0]).getFullPath();
                String pathStr = path.toString();
                this.sourcePathField.setText(pathStr);
                this.selectedFile = pathStr;
            }
            this.updatePageCompletion();
        }
    }

    protected ElementTreeSelectionDialog createBrowseDialog() {
        return new FilteredFileSelectionDialog(this.getShell(), this.sourceFileExtensions);
    }

    private GridLayout newContainerLayout(int cols) {
        GridLayout result = new GridLayout(cols, false);
        result.marginWidth = 1;
        return result;
    }

    public String getFilePath() {
        return this.filePath;
    }

    protected boolean validateDestinationGroup() {
        String path = null;
        if ("Initialization of build server is disabled. Export to Art operation can't be performed. Change your workspace preferences.".equals(this.getErrorMessage())) {
            return false;
        }
        if (this.directoryButton.getSelection()) {
            path = this.directoryDest.getText();
        } else if (this.wksSpaceButton.getSelection()) {
            path = this.wksSpaceDest.getText();
        }
        if (path == null || path.length() == 0) {
            this.setMessage("Select the destination directory to export the model.");
            this.setErrorMessage(null);
            return false;
        }
        if (this.wksSpaceButton.getSelection()) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.exists() && resource instanceof IContainer) {
                this.setErrorMessage(null);
                this.setMessage(null);
                return true;
            }
        } else if (this.directoryButton.getSelection() && this.isValidPath(path)) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage("The specified destination path is not a valid directory path.");
        return false;
    }

    private boolean isValidPath(String path) {
        boolean isValidPath = true;
        try {
            Paths.get(path, new String[0]);
        }
        catch (Exception exception) {
            isValidPath = false;
        }
        return isValidPath;
    }

    private void handleBrowseWorkspaceButtonPressed() {
        IContainer container = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(this.wksSpaceDest.getText());
        if (workspace.getRoot().exists((IPath)path)) {
            container = (IContainer)workspace.getRoot().findMember((IPath)path);
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), container, true, "Export to workspace");
        dialog.setBlockOnOpen(true);
        dialog.setValidator((ISelectionValidator)new NonVirtualContainerValidator());
        dialog.showClosedProjects(false);
        dialog.setTitle("Export ");
        dialog.setMessage("Export to workspace:");
        dialog.open();
        Object[] pathList = dialog.getResult();
        if (pathList != null && pathList.length == 1) {
            path = (IPath)pathList[0];
            this.wksSpaceDest.setText(path.toString());
            this.updatePageCompletion();
        }
    }

    private void activateDirectoryDestination() {
        this.directoryButton.setSelection(true);
        this.directoryDest.setEnabled(true);
        this.browseButtonForDirectory.setEnabled(true);
        this.wksSpaceDest.setEnabled(false);
        this.browseButtonForWks.setEnabled(false);
        if (this.validateSourceGroup()) {
            this.validateDestinationGroup();
        }
        this.updatePageCompletion();
    }

    private void activateWorkspaceDestination() {
        this.wksSpaceButton.setEnabled(true);
        this.wksSpaceDest.setEnabled(true);
        this.browseButtonForWks.setEnabled(true);
        this.directoryDest.setEnabled(false);
        this.browseButtonForDirectory.setEnabled(false);
        if (this.validateSourceGroup()) {
            this.validateDestinationGroup();
        }
        this.updatePageCompletion();
    }

    public String getDestinationPath() {
        if (this.directoryButton.getSelection()) {
            return this.directoryDest.getText();
        }
        if (this.wksSpaceButton.getSelection()) {
            IResource destination = ResourcesPlugin.getWorkspace().getRoot().findMember(this.wksSpaceDest.getText());
            return destination.getLocation().toOSString();
        }
        return null;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public boolean isWorkspaceSelected() {
        return this.wksSpaceButton.getSelection();
    }

    public boolean isDirectorySelected() {
        return this.directoryButton.getSelection();
    }

    public void setDefaultDirectoryPath(String path) {
        if (path != null) {
            this.defaultDirectoryPath = path;
            if (this.directoryButton.getSelection() && this.isValidPath(path)) {
                this.directoryDest.setText(this.defaultDirectoryPath);
            }
        }
    }

    public String getDefaultWorkspacePath() {
        return this.wksSpaceDest.getText();
    }

    public String getDefaultDirectoryPath() {
        return this.directoryDest.getText();
    }

    public void setDefaultSourceSelection(String sourceFile) {
        String selectedSourceFile = sourceFile;
        if (this.selectedFile != null) {
            selectedSourceFile = this.selectedFile;
        }
        if (selectedSourceFile != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (selectedSourceFile != null) {
                Path filePath = new Path(selectedSourceFile);
                if (workspace.getRoot().exists((IPath)filePath)) {
                    this.selectedFile = filePath.toOSString();
                    this.sourcePathField.setText(this.selectedFile);
                }
            }
        }
    }

    public void setWorkspaceSelected(boolean isWorkspaceSelected) {
        this.wksSpaceButton.setSelection(isWorkspaceSelected);
        this.directoryButton.setSelection(!isWorkspaceSelected);
        if (isWorkspaceSelected) {
            this.activateWorkspaceDestination();
        } else {
            this.activateDirectoryDestination();
        }
    }

    public void setDefaultWorkspacePath(String workspacePath) {
        if (workspacePath != null) {
            IResource resource;
            this.defaultWorkspacePath = new Path(workspacePath);
            if (this.wksSpaceButton.getSelection() && this.defaultWorkspacePath != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)this.defaultWorkspacePath)) != null && resource.exists()) {
                this.wksSpaceDest.setText(this.defaultWorkspacePath.toString());
            }
        }
    }

    protected boolean validateSourceGroup() {
        if ("Initialization of build server is disabled. Export to Art operation can't be performed. Change your workspace preferences.".equals(this.getErrorMessage())) {
            return false;
        }
        if (this.sourcePathField.getText() == null || this.sourcePathField.getText().isBlank()) {
            this.setMessage("Select the transformation configuration file to export.");
            this.setErrorMessage(null);
            return false;
        }
        String errorMessage = "The specified transformation configuration file is not valid.";
        if (this.selectedFile == null) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        IPath path = new Path(this.selectedFile).makeAbsolute();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (!this.isSupportedFileExtension(path.getFileExtension()) || resource == null || !resource.exists()) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    private boolean isSupportedFileExtension(String extension) {
        if (this.sourceFileExtensions == null || this.sourceFileExtensions.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.sourceFileExtensions.length) {
            if (this.sourceFileExtensions[i].equalsIgnoreCase(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getSourceSelection() {
        return this.selectedFile;
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(String selectedFile) {
        this.selectedFile = selectedFile;
    }

    public void handleEvent(Event event) {
    }
}

